use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
--66463
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[GetProjectId]'') AND type in (N''FN'', N''IF'', N''TF'', N''FS'', N''FT''))
   DROP FUNCTION [dbo].[GetProjectId]
'

declare @ClientPayload02 nvarchar(max) = N'
CREATE FUNCTION [dbo].[GetProjectId](@schemaName nvarchar(40))
RETURNS int
WITH SCHEMABINDING
BEGIN
    RETURN CAST(RIGHT(@schemaName, CHARINDEX (''_'', REVERSE(@schemaName)) - 1) AS int)
END
'


declare @ClientPayload03 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.triggers WHERE object_id = OBJECT_ID(N''dbo.VX_tr_OnUpdateRespondent''))
   DROP TRIGGER dbo.VX_tr_OnUpdateRespondent
'

declare @SurveyPayload01 nvarchar(max) = N'
--66176
IF EXISTS (SELECT 1 FROM sys.triggers WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.VX_tr_OnUpdateRespondent''))
   DROP TRIGGER #SURVEY SCHEMA#.VX_tr_OnUpdateRespondent
'

declare @SurveyPayload02 nvarchar(max) = N'
CREATE TRIGGER #SURVEY SCHEMA#.VX_tr_OnUpdateRespondent
    ON #SURVEY SCHEMA#.[Respondent]
    AFTER UPDATE
AS 
BEGIN
	SET NOCOUNT ON;
 
	IF UPDATE(ResCompleted) OR UPDATE(ResCallCount) OR UPDATE(ResDisposition) OR UPDATE(ResEmail)
	BEGIN
		UPDATE s
		SET
			s.CompletedOn = CASE WHEN i.ResCompleted <> d.ResCompleted THEN GETUTCDATE() ELSE s.CompletedOn END,
			s.Disposition = CASE WHEN i.ResDisposition <> d.ResDisposition THEN i.ResDisposition ELSE s.Disposition END,
			s.Email = CASE WHEN i.ResEmail <> d.ResEmail THEN i.ResEmail ELSE s.Email END
		FROM #SURVEY SCHEMA#.RespondentActivitySummary s
		INNER JOIN inserted i ON s.RespondentId = i.ResRespondent
		INNER JOIN deleted d ON i.ResRespondent = d.ResRespondent
			AND (i.ResDisposition <> d.ResDisposition
				OR i.ResEmail <> d.ResEmail
				OR i.ResCompleted <> d.ResCompleted);

		IF EXISTS (
			SELECT 1
			FROM inserted i
			INNER JOIN deleted d ON i.ResRespondent = d.ResRespondent
				AND (i.ResCompleted <> d.ResCompleted
					OR i.ResCallCount <> d.ResCallCount))
		BEGIN
			DECLARE @iProjectId int
			SET @iProjectId = [dbo].GetProjectId(OBJECT_SCHEMA_NAME(@@PROCID))
   
			UPDATE dbo.ProjectStatistics
			SET NeedsUpdate = 1
			WHERE ProjectId=@iProjectId AND NeedsUpdate=0
		END
	END
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait

        print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 2'
		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 3'
		select @SQL = replace(replace(@ClientPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL
		print 'All Client Payload done!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end

	select @TotalSurveys = count(*) from #Survey
	set @SurveyCursor = cursor forward_only for select DBName, SchemaName from #Survey for update of Processed
	open @SurveyCursor
	fetch next from @SurveyCursor into @ThisClient, @ThisSurvey
	while @@FETCH_STATUS = 0 begin
		select @SurveyCounter += 1
		select @StatusMessage = 'Updating survey "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @SurveyCounter / @TotalSurveys
		raiserror (@StatusMessage, 0, 1, @ThisSurvey, @SurveyCounter, @TotalSurveys, @StatusPercent) with nowait

		declare @SurveyExists bit = 0;
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'

		select @SQL = N'SELECT @SurveyExistsOutput = 1; if exists (select * from ' + @ThisClient + '.sys.schemas where [name] = ''' + @ThisSurvey + ''') SELECT @SurveyExistsOutput = 1 '
		exec sp_executesql @SQL, N'@SurveyExistsOutput bit out', @SurveyExists out
		--select @SurveyExists

		if @SurveyExists = 1
		BEGIN 
		   print 'Survey Payload 1'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 2'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL
		   print 'All Survey Payload done!'

        END
        ELSE 
		BEGIN
		   print '  >>>>> Survey has been deleted!'
		END

		update #Survey set Processed = 1 where current of @SurveyCursor
		fetch next from @SurveyCursor into @ThisClient, @ThisSurvey
	end

	truncate table #SurveyVerif
	fetch first from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #SurveyVerif select ''' + @ThisClient + ''', SchemaName from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName from #SurveysDone'
		exec @DBSQL @SQL
		fetch next from @ClientCursor into @ThisClient
	end

	close @ClientCursor
	close @SurveyCursor
	deallocate @ClientCursor
	deallocate @SurveyCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

	IF exists (select DBName, SchemaName from #SurveyVerif except select DBName, SchemaName from #Survey where Processed = 1) 
	BEGIN
		raiserror ('  >>>>> New survey(s) have been added or were skipped, going again!', 0, 1)
		insert into #SurveysDone select DBName, SchemaName from #Survey where Processed = 1
		truncate table #DB
		truncate table #Survey
	END 
	ELSE 
    BEGIN
	  SELECT @AllDone = 1
    END

end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone